<?php

namespace App\Models\Customer;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Area\City;
use App\Models\Area\Province;
use App\Models\Area\Subdistrict;

class Address extends Model
{
    use HasFactory;

    protected $table = 'customer_address';

    protected $keyType = 'string';

    function province(){
        return $this->belongsTo(Province::class, 'id_province', 'province_id');
    }

    function city(){
        return $this->belongsTo(City::class, 'id_city', 'city_id');
    }

    function subdistrict(){
        return $this->belongsTo(Subdistrict::class, 'id_subdistrict', 'subdistrict_id');
    }
}
