<?php

namespace App\Models\Opex\Pengeluaran;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Items extends Model
{
    use HasFactory;

    protected $table = 'op_pengeluaran_items';

    protected $appends = ['price'];

    function getPriceAttribute() {
        return $this->subtotal / $this->qty;
    }

    function category(){
        return $this->belongsTo(Category::class, 'id_category');
    }
}
