<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentMethodType extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'payment_method_types';

    protected $fillable = ['name', 'code', 'file', 'deleted_at'];
    
    public function scopeWithParameters($query, $req) {
        return $query = $query;
    }

    function items(){
        return $this->hasMany(PaymentMethod::class, 'type');
    }
}
