<?php

namespace App\Models\Product;

use App\Models\Category;
use App\Models\Venture\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Product extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'product';
    
    public function scopeWithParameters($query, $req) {
        if (!empty($req['title'])) {
            $query->where('title', 'LIKE', '%'.$req['title'].'%');
        }
        if (!empty($req['category'])) {
            $query->whereRelation('category', 'title', 'LIKE', '%'.$req['category'].'%');
        }
        if (!empty($req['package'])) {
            $query->whereRelation('package', 'title', 'LIKE', '%'.$req['package'].'%');
        }
        if (!empty($req['unit'])) {
            $query->whereRelation('unit', 'title', 'LIKE', '%'.$req['unit'].'%');
        }
        if (!empty($req['user'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'front_name', 'LIKE', '%'.$req['user'].'%');
                })->orWhere(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'back_name', 'LIKE', '%'.$req['user'].'%');
                });
            });
        }
        return $query = $query;
    }

    public function category() {
        return $this->belongsTo(Category::class, 'id_category_product')->withTrashed();
    }

    public function unit() {
        return $this->belongsTo(Unit::class, 'id_unit_product')->withTrashed();
    }

    public function package() {
        return $this->belongsTo(Package::class, 'id_package_product')->withTrashed();
    }

    public function user() {
        return $this->belongsTo(User::class, 'id_user')->withTrashed();
    }
}
