<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Unit extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'unit_product';
    
    protected $fillable = ['title'];
    
    public function scopeWithParameters($query, $req) {
        if (!empty($req['title'])) {
            $query->where('title', 'LIKE', '%'.$req['title'].'%');
        }
        return $query = $query;
    }
}
