<?php

namespace App\Models\Shopping;

use App\Models\Venture\User;
use App\Models\Vendor\Profile;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Builder;

class Detail extends Model
{
    use HasFactory;

    protected $table = 'shopping';

    protected $keyType = 'string';

    protected $appends = ['purchase_dated'];

    function getPurchaseDatedAttribute() {
        return date('d/m/Y', strtotime($this->purchase_date));
    }

    public function scopeWithParameters($query, $req) {
        if (!empty($req['id'])) {
            $query->where('id', $req['id']);
        }

        if (!empty($req['vendor'])) {
            $query->whereRelation('vendor', 'name_vendor', 'LIKE', '%'.$req['vendor'].'%');
        }

        if (!empty($req['buyer'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'front_name', 'LIKE', '%'.$req['buyer'].'%');
                })->orWhere(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'back_name', 'LIKE', '%'.$req['buyer'].'%');
                });
            });
        }

        if (!empty($req['start_date'])) {
            $query->whereDate('purchase_date', '>=', $req['start_date']);
        }

        if (!empty($req['end_date'])) {
            $query->whereDate('purchase_date', '<=', $req['end_date']);
        }

        if (!empty($req['role'])) {
            $query->whereRelation('user', 'role', $req['role']);
        }
        return $query = $query;
    }
    
    function user(){
        return $this->belongsTo(User::class, 'id_user');
    }

    function vendor(){
        return $this->belongsTo(Profile::class, 'id_vendor');
    }

    function items(){
        return $this->hasMany(Item::class, 'id_shopping');
    }
}
