<?php

namespace App\Models\Shopping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    use HasFactory;

    protected $table = 'shopping_items';

    protected $casts = [
        'product' => 'json'
    ];

    protected $appends = ['price'];

    function getPriceAttribute() {
        return $this->subtotal / $this->qty;
    }
}
