<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
  use HasFactory;

  protected $table = 'slider';

  protected $fillable = ['id_admin', 'file', 'urutan', 'title', 'url', 'active'];

  public function scopeWithParameters($query, $req) {
    if (!empty($req['_activity'])) {
      $query->where('active', $req['active'] ?? 'no');
    }
    if (!empty($req['title'])) {
      $query->where('title', 'LIKE', '%'.$req['title'].'%');
    }
    return $query = $query;
  }

}
