<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TopUp extends Model
{
    use HasFactory;

    protected $table = 'top_up';
    
    protected $fillable = ['nominal', 'date', 'admin_id', 'external_id', 'response', 'payment', 'proof_of_payment'];

    protected $casts = [
        'response' => 'json',
        'payment' => 'json'
    ];
    
    public function scopeWithParameters($query, $req) {
        if (!empty($req['start_date'])) {
            $query->whereData('date', '>=', $req['start_date']);
        }
        if (!empty($req['end_date'])) {
            $query->whereData('date', '<=', $req['end_date']);
        }
        if (!empty($req['admin'])) {
            $query->whereRelation('admin', 'name', 'like', '%'.$req['admin'].'%');
        }
        return $query = $query;
    }

    function admin() {
        return $this->belongsTo(User::class, 'admin_id');
    }
}
