<?php

namespace App\Models\Venture;

use App\Models\Area\City;
use App\Models\Area\Province;
use App\Models\Area\Subdistrict;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bussines extends Model
{
    use HasFactory;

    protected $table = 'user_bussines';
    
    protected $fillable = [
        'id', 'name_bussines', 'id_province', 'id_city', 'id_subdistrict', 'village', 'postcode', 'address', 'latitude', 'longitude', 'verified', 'status', 'akta', 'npwp', 'nib', 'sk_kemenkum', 'profile_bussines'
    ];

    function province(){
        return $this->belongsTo(Province::class, 'id_province', 'province_id');
    }

    function city(){
        return $this->belongsTo(City::class, 'id_city', 'city_id');
    }

    function subdistrict(){
        return $this->belongsTo(Subdistrict::class, 'id_subdistrict', 'subdistrict_id');
    }
}
