<?php

namespace App\Models\Venture;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Saldo extends Model
{
    use HasFactory;

    protected $table = 'user_saldo';
    
    protected $fillable = ['user_id', 'setor', 'modal', 'file', 'result', 'periode'];

    public function scopeWithParameters($query, $req) {
        if (!empty($req['user_id'])) {
            $query->where('user_id', $req['user_id']);
        }
        if (!empty($req['periode'])) {
            $query->where('periode', $req['periode']);
        }
        return $query = $query;
    }
}
