<?php

namespace App\Models\Venture;

use App\Models\Subscriptions;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Subscription extends Model
{
    use HasFactory;

    protected $table = 'user_subscription';
    
    public function scopeWithParameters($query, $req) {
        if (!empty($req['user'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'front_name', 'LIKE', '%'.$req['user'].'%');
                })->orWhere(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'back_name', 'LIKE', '%'.$req['user'].'%');
                });
            });
        }
        if (!empty($req['subscription'])) {
            $query->whereRelation('subscription', 'title', 'LIKE', '%'.$req['subscription'].'%');
        }
        return $query = $query;
    }

    function user(){
        return $this->belongsTo(User::class, 'user_id');
    }

    function subscription(){
        return $this->belongsTo(Subscriptions::class, 'subscription_id');
    }
}
