<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class VirtualAccount extends Model
{
    use HasFactory;

    protected $table = 'admin_va_accounts';
    
    protected $fillable = ['id_admin', 'va_id', 'va_bank_code', 'va_name', 'va_response', 'status'];

    protected $casts = [
        'va_response' => 'json'
    ];
    
    protected static function booted() {
        static::addGlobalScope('ancient', function (Builder $query) {
            $query->where('id_admin', auth()->user()->id);
        });
    }

    public function scopeWithParameters($query, $req) {
        return $query = $query;
    }
}
