<?php

namespace App\Models;

use App\Models\Venture\User;
use App\Models\User as ModelsUser;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WithdrawUser extends Model
{
    use HasFactory;

    protected $table = 'admin_withdraw';
    
    protected $fillable = [
        'id_user',
        'date',
        'nominal',
        'type',
        'file',
        'handled_by',
    ];

    public function scopeFilter($query, $req) {
        if (!empty($req['type'])) {
            $query->where('type', $req['type']);
        }
        if (!empty($req['start_date'])) {
            $query->whereDate('date', '>=', $req['start_date']);
        }
        if (!empty($req['end_date'])) {
            $query->whereDate('date', '<=', $req['end_date']);
        }
        if (!empty($req['user'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'front_name', 'like', '%'.$req['user'].'%');
                })->orWhere(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'back_name', 'like', '%'.$req['user'].'%');
                });
            });
        }
        if (!empty($req['admin'])) {
            $query->whereRelation('admin', 'name', 'like', '%'.$req['admin'].'%');
        }
        return $query = $query;
    }

    function user(){
        return $this->belongsTo(User::class, 'id_user');
    }

    function admin(){
        return $this->belongsTo(ModelsUser::class, 'handled_by');
    }
}
