<?php

namespace App\Repositories;

use App\Models\Area\City;
use App\Models\Area\Province;
use App\Models\Area\Subdistrict;
use Illuminate\Support\Facades\DB;

class AreaRepository {

  function province(){
    return Province::orderBy('province_name', 'asc')->get();
  }

  function city($id){
    return City::where('province_id', $id)->orderBy('city_name', 'asc')->get();
  }

  function subdistrict($id){
    return Subdistrict::where('city_id', $id)->orderBy('subdistrict_name', 'asc')->get();
  }

}