<?php

namespace App\Repositories;

use App\Models\Branch;
use App\Models\Profession;

class BranchRepository {

  function get($req = []){
    $data = Branch::orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function find($id){
    return Branch::find($id);
  }

  function count(){
    return Branch::count();
  }

}