<?php

namespace App\Repositories;

use App\Models\Customer\Profile;

class CustomerRepository {

  function get($req = []){
    $data = Profile::with(['user', 'address.province', 'address.city', 'address.subdistrict'])->orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return Profile::with(['user', 'address.province', 'address.city', 'address.subdistrict'])->find($id);
  }

  function find($id){
    return Profile::find($id);
  }

  function count(){
    return Profile::count();
  }

}