<?php

namespace App\Repositories\Opex;

use App\Models\Opex\Pengeluaran\Detail;

class PengeluaranRepository {

  function get($req = []){
    $data = Detail::with('user')->withSum('items', 'subtotal')->orderBy('created_at', 'desc')->withParameters($req);
    $result = $data->paginate(100)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return Detail::with(['user', 'items.category'])->withSum('items', 'subtotal')->find($id);
  }

  function find($id){
    return Detail::find($id);
  }

  function count(){
    return Detail::count();
  }

}