<?php

namespace App\Repositories;

use App\Models\PaymentMethod;

class PaymentMethodRepository {

  function get($req = []){
    $data = PaymentMethod::with('type_as')->orderBy('id', 'desc')->filter(array_merge($req, [
      'type_as_exists' => 1
    ]));
    $result = $data->withTrashed()->get()->map(function($item) {
      return $item;
    });
    return $result;
  }

  function clean($req = []){
    $data = PaymentMethod::with('type_as')->orderBy('id', 'desc')->filter(array_merge($req, [
      'type_as_exists' => 1
    ]));
    $result = $data->get()->map(function($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return PaymentMethod::with('type_as')->filter(['type_as_exists' => 1])
      ->find($id);
  }

  function find($id){
    return PaymentMethod::with('type_as')->filter(['type_as_exists' => 1])->find($id);
  }

  function findWithTrashed($id){
    return PaymentMethod::with('type_as')->filter(['type_as_exists' => 1])->withTrashed()->find($id);
  }

  function count($req = []){
    return PaymentMethod::with('type_as')->filter(array_merge($req, [
      'type_as_exists' => 1
    ]))->count();
  }

}