<?php

namespace App\Repositories\Product;

use App\Models\Product\Package;

class PackageRepository {

  function get($req = []){
    $data = Package::orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function find($id){
    return Package::find($id);
  }

  function count($req = []){
    return Package::withParameters($req)->count();
  }

}