<?php

namespace App\Repositories\Product;

use App\Models\Product\Product;

class ProductRepository {

  function get($req = []){
    $data = Product::with(['category', 'unit', 'package'])->orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return Product::with(['category', 'unit', 'package', 'user'])->find($id);
  }

  function find($id){
    return Product::find($id);
  }

  function count(){
    return Product::count();
  }

}