<?php

namespace App\Repositories\Product;

use App\Models\Product\Unit;

class UnitRepository {

  function get($req = []){
    $data = Unit::orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function find($id){
    return Unit::find($id);
  }

  function count($req = []){
    return Unit::withParameters($req)->count();
  }

}