<?php

namespace App\Repositories;

use App\Models\Revenue;

class RevenueRepository {
  
  function get($req = []){
    $data = Revenue::with('admin')->orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return Revenue::with('admin')->find($id);
  }

  function find($id){
    return Revenue::find($id);
  }

  function sum($field = 'nominal', $req = []){
    return Revenue::withParameters($req)->sum($field);
  }
}