<?php

namespace App\Repositories;

use App\Models\Shopping\Detail;

class ShoppingRepository {

  function get($req = []){
    $data = Detail::with(['user', 'vendor'])->withCount('items')->orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return Detail::with(['user', 'vendor', 'items'])->find($id);
  }

  function find($id){
    return Detail::find($id);
  }

  function count(){
    return Detail::count();
  }

}