<?php

namespace App\Repositories;

use App\Models\User;
use App\Models\Feature;
use App\Models\Authority;

class UserRepository {
  
  static function get($req = []){
    $data = User::with('authority')->orderBy('id', 'desc')->whereNotIn('id', [auth()->user()->id])->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function find($id){
    return User::find($id);
  }

  function notMe($id){
    return User::whereNotIn('id', [auth()->user()->id])->where('id', $id)->first();
  }

  function findData(){
    $data = User::find(auth()->user()->id);

    if(!$data){
      return $data;
    }

    $authority = Authority::withTrashed()->find($data->authorities_id);
    $codes = json_decode($authority->code, true);
    $access = [];
    foreach ($codes as $code) {
      $getCode = Feature::find($code);
      if ($getCode) {
        $access[] = $getCode->code;
      }
    }
    $authority['code'] = $access;
    $data['authority'] = $authority;
    return $data;
  }

  function count(){
    return User::orderBy('id', 'desc')->count();
  }

}