<?php

namespace App\Repositories\Venture;

use App\Models\Venture\Saldo;

class WalletRepository {

  function get($req = []){
    $data = Saldo::orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function find($id){
    return Saldo::find($id);
  }

  function count(){
    return Saldo::count();
  }

}