<?php

namespace App\Repositories\Venture;

use App\Models\Venture\Withdraw;

class WithdrawRepository {

  function get($req = []){
    $data = Withdraw::with('user')->orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }
  
  function findWithRelation($id){
    return Withdraw::with('user')->find($id);
  }

  function find($id){
    return Withdraw::find($id);
  }

  function count(){
    return Withdraw::count();
  }

  function sum($field = 'nominal', $req = []){
    return Withdraw::withParameters($req)->sum($field);
  }

}