<?php

namespace App\Repositories;

use App\Models\WithdrawSubscribe;

class WithdrawSubscribeRepository {
  
  function get($req = []){
    $data = WithdrawSubscribe::with('bank')->filter($req)->orderBy('id', 'desc');
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findByJsonAndAmount($json_field, $value, $amount){
    return WithdrawSubscribe::where($json_field, $value)->where('total', $amount)->latest()->first();
  }

  function where($req = []){
    return WithdrawSubscribe::filter($req);
  }

}