<?php

namespace App\Services;

use App\Models\Authority;
use Illuminate\Http\Request;
use InvalidArgumentException;

class AuthorityService {

  public function __construct(
    private ValidationService $validation
  ) {
    
  }

  function store(Request $req){
    $this->validation->authority($req, 'create');

    Authority::create([
      'title' => $req->title,
      'code' => json_encode($req->code),
    ]);

    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('authority')
    ];
  }

  function update(Request $req){
    $this->validation->authority($req, 'update');

    $find = Authority::find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 500);
    }
    
    $find->update([
      'title' => $req->title,
      'code' => json_encode($req->code),
    ]);

    return [
      'message' => config('message.UPDATE_SUCCESS'),
      'url' => url('authority')
    ];
  }

  function delete(Request $req){
    $data = Authority::find($req->id);
    
    if (!$data) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 500);
    }

    $data->delete();

    return [
      'message' => config('message.DELETE_SUCCESS'),
    ];
  }

  function container(Request $req, $action){
    try {

      if ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'update') {
        $e = $this->update($req);
      } elseif ($action == 'delete') {
        $e = $this->delete($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}