<?php

namespace App\Services;

use App\Models\Category;
use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Services\PartialService;
use App\Services\ValidationService;
use App\Repositories\CategoryRepository;

class CategoryService {

  public function __construct(
    private PartialService $partial,
    private CategoryRepository $repository,
    private ValidationService $validation
  ) {
  
  }

  function store(Request $req){
    $this->validation->category($req, 'store');

    Category::create($req->only(['title', 'type']));

    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('categories')
    ];
  }

  function update(Request $req){
    $this->validation->category($req, 'update');

    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    $find->update($req->only(['title', 'type']));

    return [
      'message' => config('message.UPDATE_SUCCESS'),
      'url' => url('categories')
    ];
  }

  function delete(Request $req){
    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    $find->delete();

    return [
      'message' => config('message.DELETE_SUCCESS'),
    ];
  }

  function container(Request $req, $action){
    try {

      if ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'update') {
        $e = $this->update($req);
      } elseif ($action == 'delete') {
        $e = $this->delete($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}