<?php

namespace App\Services;

use App\Models\Configuration;
use Illuminate\Http\Request;
use App\Services\PartialService;

class ConfigurationService {

  public function __construct(
    private PartialService $partial
  ) {
  
  }

  function store(Request $req){
    try {

      $find = Configuration::first();

      $find->update(array_merge([
        'web_icon' => $this->partial->uploadImage($req->web_icon, 'configuration/icon', 600, null, $find->web_icon), 
        'mark_icon' => $this->partial->uploadImage($req->mark_icon, 'configuration/mark', 600, null,  $find->mark_icon), 
      ], $req->only([
        'title', 'meta_keyword', 'meta_description', 'description','account_number', 'account_name', 'account_bank', 'email_getotp',
      ])));

      return response()->json([
        'code' => 200,
        'success' => true,
        'message' => config('message.UPDATE_SUCCESS')
      ]);
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}