<?php

namespace App\Services;

use App\Models\Notification\History;
use App\Models\Notification\User;
use Illuminate\Http\Request;
use InvalidArgumentException;
use Illuminate\Support\Facades\Http;

class NotificationService 
{
	public $app_id;
	public $token;

	public function __construct() {
		$this->app_id = '1b2784cc-365d-430f-ab0c-3d9af97824ee';
		$this->token = 'Mzk3M2MyY2ItMDE2NS00N2U3LTlmOTgtNDFmM2Q5ZWY0MDli';
	}

	private function oneSignal($head, $contents, $extend = "", $user = ""){
		$fields = [
		  'app_id' => $this->app_id,
			'channel_for_external_user_ids' => 'push',
			'data' => ['foo' => 'bar'],
			'contents' => ['en' => $contents],
			'headings' => ['en' => $head]
		];

		if (!empty($user)) {
			$fields = array_merge($fields, [
				'include_external_user_ids' => ["$user"]
			]);
		} else {
			$fields = array_merge($fields, [
				'included_segments' => ['Subscribed Users']
			]);
		}

		if ($extend) {
		  $fields = array_merge($fields, $extend);
		}

		$response = Http::withoutVerifying()->withHeaders([
			'Content-Type' => 'application/json; charset=utf-8',
		  'Authorization' => 'Basic '.$this->token
		])->acceptJson()->post('https://onesignal.com/api/v1/notifications', $fields);
	
		return json_decode($response->body(), true);
	}

	/**
	 * BEGINN SCRIPT
	 */

	function store($params, $user_id, $extend = null){
		$notification = History::create($params);

		$user = User::create([
			'notification_id' => $notification->id,
			'user_id' => $user_id,
			'is_read' => 0,
		]);

		$oneSignal = $this->oneSignal($params['title'], $params['description'], $extend, $user_id);

		return [
			'notification' => $notification,
			'user' => $user,
			'oneSignal' => $oneSignal,
		];
	}
}