<?php

namespace App\Services;

use Illuminate\Filesystem\Filesystem;
use InvalidArgumentException;
use Intervention\Image\ImageManagerStatic as Image;

class PartialService {

  public function upload($img, $folder, $default = null) {
    try {
      if (!$img && $default) {
        return $default;
      }

      $folder_ext = explode('/', $folder);
      $path = env('PATH_ASSET').$folder;
      if (!file_exists($path)) {
        mkdir($path, 0755, true);
      }
      $extension = $img->getClientOriginalExtension();
      $file = rand(000000, 999999).'_'.$folder_ext[0].'.'.$extension;
      $path = $img->move($path, $file);
      return $folder.'/'.$file;
    } catch (\Throwable $th) {
      throw new InvalidArgumentException($th->getMessage(), 500);
    }
  }

  public function uploadImage($img, $folder, $width, $height=null, $default=null) 
  {
    try {
      if (empty($img) && $default) {
        return $default;
      }

      $folder_ext = explode('/', $folder);
      $path = env('PATH_ASSET').$folder;
      if (!file_exists($path)) {
        mkdir($path, 0755, true);
      }

      $extension = $img->getClientOriginalExtension();
      $file = rand(000000, 999999).'_'.$folder_ext[0].'.'.$extension;
      $save = "$path/$file";

      $upload = Image::make($img->getPathName());
      
      if($height){
        $upload->resize($width, $height);
      }else{
        $upload->resize($width, null, function ($constraint) {
          $constraint->aspectRatio();
        });
      }

      $upload->orientate();
      $upload->save($save);
      
      return $folder.'/'.$file;
    } catch (\Throwable $th) {
      throw new InvalidArgumentException($th, 500);
    }
  }

  
  function createFile($folder, $name, $content) {
    if (!empty($content)) {
      $path = 'storage/docs/'.$folder;
      if (!file_exists($path)) {
        mkdir($path, 0755, true);
      }
      $file = fopen($path.'/'.$name.'.txt', 'w') or die("");
      fwrite($file, $content);
    }
  }

  function deleteFile($img) {
    if(file_exists($img)){
      unlink($img);
    }
  }

  function deleteFolder($folder) {
    try {
      $path = storage_path('app/public/upload/'.$folder);
      $file = new Filesystem;
      $file->cleanDirectory($path);
      rmdir($path);
    } catch (\Throwable $th) {
      //throw $th;
    }
  }
  
}