<?php

namespace App\Services;

use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Services\PartialService;
use App\Repositories\PaymentMethodRepository;

class PaymentMethodService {

  public function __construct(
    private PartialService $partial,
    private PaymentMethodRepository $repository,
  ) {
  
  }


  function delete(Request $req){
    $find = $this->repository->findWithTrashed($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    if ($find->deleted_at) {
      $find->update([
        'deleted_at' => null
      ]);
    } else {
      $find->delete();
    }

    return [
      'message' => config('message.DELETE_SUCCESS'),
    ];
  }

  function update(Request $req){
    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    $oldFile = $find->file;

    $find->update(array_merge([
      'file' => $this->partial->uploadImage($req->file, 'payment-method', 600, null, $oldFile)
    ], $req->only(['title', 'type', 'steps', 'tax_type', 'tax'])));

    if ($req->file) {
      $this->partial->deleteFile($oldFile);
    }

    return [
      'message' => config('message.UPDATE_SUCCESS'),
      'url' => url('payment-method')
    ];
  }

  function container(Request $req, $action){
    try {

      if ($action == 'delete') {
        $e = $this->delete($req);
      } elseif ($action == 'update') {
        $e = $this->update($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}