<?php

namespace App\Services\Product;

use Illuminate\Support\Str;
use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Models\Product\Product;
use App\Services\PartialService;
use App\Services\ValidationService;
use App\Repositories\Product\ProductRepository;

class ProductService {

  public function __construct(
    private PartialService $partial,
    private ProductRepository $repository,
    private ValidationService $validation
  ) {
  
  }

  function store(Request $req){
    $this->validation->product($req, 'store');

    Product::create(array_merge([
      'sku' => Str::random(15)
    ], $req->only([
      'id_category_product', 'title', 'id_unit_product', 'id_package_product'
    ])));
    
    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('products')
    ];
  }

  function update(Request $req){
    $this->validation->product($req, 'update');

    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    $find->update($req->only([
      'id_category_product', 'title', 'id_unit_product', 'id_package_product'
    ]));

    return [
      'message' => config('message.UPDATE_SUCCESS'),
      'url' => url('products')
    ];
  }

  function delete(Request $req){
    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    $find->delete();

    return [
      'message' => config('message.DELETE_SUCCESS'),
    ];
  }

  function container(Request $req, $action){
    try {

      if ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'update') {
        $e = $this->update($req);
      } elseif ($action == 'delete') {
        $e = $this->delete($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}