<?php

namespace App\Services;

use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Services\ValidationService;
use App\Repositories\UserRepository;
use Illuminate\Support\Facades\Hash;

class ProfileService {

  public function __construct(
    private UserRepository $repository,
    private ValidationService $validation
  ) {
    
  }

  function update(Request $req){
    $this->validation->profile($req, 'update');

    $find = $this->repository->find(auth()->user()->id);
    
    $find->update($req->only([
      'name', 'email'
    ]));

    return [
      'message' => config('message.UPDATE_SUCCESS'),
    ];
  }

  function password(Request $req){
    $this->validation->profile($req, 'password');

    $find = $this->repository->find(auth()->user()->id);

    if (!Hash::check($req->curr_password, $find->password)) {
      throw new InvalidArgumentException('Password sekarang yang anda masukan salah.', 422);
    }

    $find->update([
      'password' => Hash::make($req->password)
    ]);

    return [
      'message' => 'Password berhasil diubah.'
    ];
  }


  function container(Request $req, $action){
    try {

      if ($action == 'update') {
        $e = $this->update($req);
      } elseif ($action == 'password') {
        $e = $this->password($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }
  
}