<?php

namespace App\Services\Venture;

use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Services\PartialService;
use Illuminate\Support\Facades\DB;
use App\Services\NotificationService;
use App\Repositories\Venture\WithdrawRepository;

class WithdrawService {

  public function __construct(
    private PartialService $partial,
    private WithdrawRepository $repository,
    private NotificationService $notification,
  ) {
  
  }

  function handle(Request $req){
    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    if ($find->status != 'pending') {
      throw new InvalidArgumentException('Proses gagal!', 404);
    }

    if (array_search($find->status, ['pending', 'accept', 'rejected']) === false) {
      throw new InvalidArgumentException('Proses gagal!', 404);
    }

    $update = $find->update([
      'status' => $req->status,
      'handled_by' => auth()->user()->id
    ]);

    $notification = $this->notification->store([
      'type' => 'withdraw',
      'title' => "Status: $req->status",
      'description' => "Withdraw anda telah di `$req->status`",
      'key' => [
        'id' => $find->id,
        'id_user' => $find->id_user,
        'nominal' => $find->nominal,
        'status' => $find->status,
        'account' => $find->account,
      ],
    ], $find->id_user, [
      'app_url' => 'NotifDetailWithdraw/'.$find->id
    ]);

    return [
      'message' => 'Data berhasil disimpan!',
      'url' => url('venture/withdraw'),
    ];
  }

  function container(Request $req, $action){
    DB::beginTransaction();

    try {
      if ($action == 'handle') {
        $e = $this->handle($req);
      }

      DB::commit();

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      DB::rollback();

      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}