<?php

namespace App\Services\Xendit;

use Xendit\Retail;
use Xendit\Xendit;
use InvalidArgumentException;
use Illuminate\Support\Facades\DB;
use App\Models\VirtualAccount as ModelsVirtualAccount;

class CStore {

  public function __construct(
    
  ) {
    Xendit::setApiKey(env('XENDIT_PRODUCTION') ? env('XENDIT_KEY_PROD') : env('XENDIT_KEY_DEV'));
  }

  public function findAccount(string $cstore_code, int $total, string $external_id)
  {
    $array = [];

    $user_va = ModelsVirtualAccount::where([
      'va_bank_code' => strtoupper($cstore_code),
      'status' => 'ready'
    ])->first();

    if (!$user_va) {
      return $this->createAccount($cstore_code, $total, $external_id);
    }

    $check_va_account = $this->checkAccount($user_va->va_id);
    if (is_null($check_va_account) or count($check_va_account) == 0) {
      return $this->createAccount($cstore_code, $total, $external_id);
    }

    $update = $user_va->update(['status' => 'used']);

    return $user_va;
  }

  public function checkAccount(string $va_id): ?array
  {
    try {
      return Retail::retrieve($va_id);
    } catch (\Throwable $th) {
      return null;
    }
  }

  function createAccount(string $cstore_code, int $total, string $external_id) {
    DB::beginTransaction();

    $name = auth()->user()->name;

    $cstore = strtoupper($cstore_code);

    date_default_timezone_set('UTC');

    $params = [
      "is_closed" => true,
      "external_id" => $external_id,
      "retail_outlet_name" => $cstore,
      "name" => $name,
      "expected_amount" => $total,
      "expiration_date" => date('Y-m-d H:i:s', strtotime('+1 days'))
    ];

    $response = Retail::create($params);

    try {
      date_default_timezone_set('Asia/Jakarta');

      $user_va = ModelsVirtualAccount::create([
        'id_admin' => auth()->user()->id,
        'va_id' => $response['id'],
        'va_bank_code' => $response['retail_outlet_name'],
        'va_name' => $name,
        'va_response' => $response,
      ]);
      DB::commit();
      return $user_va;
    } catch (\Throwable $th) {
      DB::rollBack();
      throw new InvalidArgumentException($th->getMessage(), 500);
    }
  }

  public function updateExceptedAmount(string $va_id, int $amount)
  {
    $field = ['expected_amount' => $amount];

    $response = Retail::update($va_id, $field);

    try {

      $user_va = ModelsVirtualAccount::where('va_id', $va_id)->first();

      $update = $user_va->update([
        'va_response' => $response
      ]);

      DB::commit();
      return $user_va;
      //return
    } catch (\Throwable $th) {
      DB::rollBack();
      throw new InvalidArgumentException($th->getMessage(), 500);
    }
  }

}