<?php

namespace App\Services\Xendit;

use Xendit\Xendit;
use Xendit\Disbursements;
use InvalidArgumentException;

class Payout {

    public function __construct(
    
    ) {
        Xendit::setApiKey(env('XENDIT_PRODUCTION') ? env('XENDIT_KEY_PROD') : env('XENDIT_KEY_DEV'));
    }

    function store($bank_code, $account_number, $account_name, $nominal) {
        $bank = strtoupper($bank_code);

        $description = auth()->user()->name . " melakukan payout melalui $bank sebesar " . number_format($nominal);

        $params = [
            'external_id' => 'payout-' . rand(111111111, 999999999),
            'amount' => $nominal,
            'bank_code' => strtoupper($bank_code),
            'account_holder_name' => $account_name,
            'account_number' => $account_number,
            'description' => $description,
            'X-IDEMPOTENCY-KEY'
        ];

        return Disbursements::create($params);
    }


}