<?php

namespace App\Services\Xendit;

use Xendit\Xendit;
use Xendit\VirtualAccounts;
use InvalidArgumentException;
use Illuminate\Support\Facades\DB;
use App\Models\VirtualAccount as ModelsVirtualAccount;

class VirtualAccount {

  public function __construct(
    
  ) {
    Xendit::setApiKey(env('XENDIT_PRODUCTION') ? env('XENDIT_KEY_PROD') : env('XENDIT_KEY_DEV'));
  }

  function checkAccount(string $va_id): ?array {
    try {
      return VirtualAccounts::retrieve($va_id);
    } catch (\Throwable $th) {
      return null;
    }
  }

  function findAccount(string $bank_code, string $external_id, int $total) {
    $user_va = ModelsVirtualAccount::where([
      'va_bank_code' => strtoupper($bank_code), 
      'status' => 'ready', 
    ])->first();

    if (!$user_va) {
      return [
        'new' => true,
        'e' => $this->createAccount($bank_code, $external_id, $total)
      ];
    }

    $check_va_account = $this->checkAccount($user_va->va_id);
    if (is_null($check_va_account) or count($check_va_account) == 0) {
      return [
        'new' => true,
        'e' => $this->createAccount($bank_code, $external_id, $total)
      ];
    }

    $update = $user_va->update(['status' => 'used']);

    return [
      'new' => false,
      'e' => $user_va
    ];

  }

  function createAccount(string $bank_code, string $external_id, int $total) {
    DB::beginTransaction();

    $name = auth()->user()->name;

    date_default_timezone_set('UTC');

    $params = [
      "is_closed" => true,
      "external_id" => $external_id,
      "bank_code" => strtoupper($bank_code),
      "name" => $name,
      "expected_amount" => $total,
      "expiration_date" => date('Y-m-d H:i:s', strtotime('+1 days'))
    ];

    $response = VirtualAccounts::create($params);

    try {
      date_default_timezone_set('Asia/Jakarta');

      $user_va = ModelsVirtualAccount::create([
        'id_admin' => auth()->user()->id,
        'va_id' => $response['id'],
        'va_bank_code' => $response['bank_code'],
        'va_name' => $name,
        'va_response' => $response,
        'status' => 'used'
      ]);
      DB::commit();
      return $user_va;
    } catch (\Throwable $th) {
      DB::rollBack();
      throw new InvalidArgumentException($th->getMessage(), 500);
    }
  }

  function updateExceptedAmount(string $va_id, int $amount)
  {
    $field = [
      'expected_amount' => $amount,
    ];

    $response = VirtualAccounts::update($va_id, $field);

    try {

      $user_va = ModelsVirtualAccount::where('va_id', $va_id)->first();

      $update = $user_va->update([
        'va_response' => $response
      ]);

      DB::commit();
      return $user_va;
      //return
    } catch (\Throwable $th) {
      DB::rollBack();
      throw new InvalidArgumentException($th->getMessage(), 500);
    }
  }

}