<?php

namespace App\View\Components\Partial;

use Illuminate\Http\Request;
use Illuminate\View\Component;

class TabRole extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */

    public $href;
    public $req;

    public function __construct(Request $req, $href)
    {
        $this->req = $req;
        $this->href = $href;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        return view('components.partial.tab-role', [
            'query' => http_build_query($this->req->except('role'))
        ]);
    }
}
