<?php

namespace App\View\Components\Venture;

use App\Models\Configuration;
use Illuminate\View\Component;
use App\Repositories\AreaRepository;
use App\Repositories\BankRepository;
use App\Repositories\ProfessionRepository;

class Form extends Component
{

    public $action;
    public $item;

    public function __construct(
        private ProfessionRepository $profession,
        private AreaRepository $area,
        private BankRepository $bank,
        $action = 'ventures/_store',
        $item = null
    ) {
        $this->action = $action;
        $this->item = $item;
    }

  
    public function render()
    {
        return view('components.venture.form', [
            'professions' => $this->profession->all(),
            'banks' => $this->bank->get(),
            'provinces' => $this->area->province(),
            'configuration' => Configuration::first()
        ]);
    }
}
