<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-search.ar class="col-md-12 mb-3" />

      <x-partial.tab-role href="ar">
        <thead>
          <tr>
            <th class="w-10px">No</th>
            <th>ID</th>
            <th>Dibuat Oleh</th>
            <th>Jatuh Tempo</th>
            <th>Pelanggan</th>
            <th>Total Tagihan</th>
            <th class="w-100px">Aksi</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($collection as $key => $item)
            <tr id="data-{{$item->id}}">
              <td class="numbering">{{no($key)}}</td>
              <td>{{$item->id}}</td>
              <td>{{$item->user?->name ?? '-'}}</td>
              <td>{{$item->due_dated}}</td>
              <td>{{$item->customer?->name ?? '-'}}</td>
              <td>Rp {{number_format($item->items_sum_subtotal)}}</td>
              <td id="action-{{$item->id}}">
                <a 
                  href="{{url('po/find/'.$item->id)}}" 
                  class="btn btn-warning btn-sm" target="_blank">
                  <i class="fas fa-link mr-2"></i>
                  Detail
                </a>
              </td>
            </tr>
          @endforeach
        </tbody>

        <x-slot name="extra">
          {{$collection->links('vendor.pagination.bootstrap-5')}}
        </x-slot>
      </x-partial.table-content>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/date-input.js')}}"></script>
  </x-slot>

</x-layout>