<div class="card">
  <div class="card-header bg-primary">
    <h4 class="card-title">Tarik Dana</h4>
  </div>
  <form action="{{url('revenue/'.$action.'/store')}}" method="post" class="_form">
    <div class="card-body">
      <input type="hidden" name="type" value="{{$action}}" />
      <div class="row">
        <x-form.input 
          div="col-md-3" label="Tanggal" 
          name="date" type="date" max="{{date('Y-m-d')}}" />
        <x-form.input 
          div="col-md-9" label="Nominal Penarikan" name="nominal" 
          placeholder="Masukan nominal penarikan" class="inputRupiah" />
      </div>
      
      <div class="row">
        <x-form.input 
          div="col-md-4" readonly
          label="Ditarik Oleh" value="{{auth()->user()->name}}" />
        <x-form.select 
          div="col-md-8" label="Pengguna" name="id_user" class="getUser"
          :collection="[]" :option="['id', ['name']]" />
      </div>
      <x-form.image 
        label="Bukti Transfer" name="file"
        id="file" required="off" />
    </div>
    <div class="card-footer">
      <button type="submit" class="btn btn-primary">Tarik</button>
    </div>
  </form>
</div>

@push('css')
  <link rel="stylesheet" type="text/css" href="{{_asset('plugins/select2/css/select2.min.css')}}">
  <link rel="stylesheet" type="text/css" href="{{_asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')}}">
@endpush

@push('js')
  <script type="text/javascript" src="{{_asset('js/rupiah.js')}}"></script>
  <script type="text/javascript" src="{{_asset('plugins/select2/js/select2.full.min.js')}}"></script>
  <script>
    $(".getUser").select2({
      minimumInputLength: 2,
      ajax: {
        url: `{{url('getUser')}}`,
        dataType: 'json',
        quietMillis: 50,
        data: function (req) {
          return {...req};
        },
        processResults: function (data) {
          if (data.code == 500) {
            return false;
          }
          var res = data.map(function (item) {
            return {
              id: item.id,
              text: item.name
            };
          });
          return {
            results: res
          };
        }
      }
    });
  </script>
@endpush