<x-partial.tab-role href="ventures">
  <thead>
    <tr>
      <th class="w-10px">No</th>
      <th>Nama Identitas</th>
      <th>Role</th>
      <th>Nama Usaha</th>
      <th>Porsi Pembagian</th>
      <th>Langganan</th>
      <th>NIK</th>
      <th>Profesi</th>
      <th>No. Handphone</th>
      <th>Email</th>
      <th>KTP</th>
      <th>NPWP</th>
      <th>Aksi</th>
    </tr>
  </thead>
  <tbody>
    @foreach ($collection as $key => $item)
      <tr id="data-{{$item->id}}">
        <td class="numbering w-10px">{{no($key)}}</td>
        <td>{{$item->name}}</td>
        <td>{{$item->role}}</td>
        <td>{{$item->bussines?->name_bussines ?? '-'}}</td>
        <td>{{$item->share_portion}}</td>
        <td>
          @if ($item->subscription)
            <b>{{$item->subscription->subscription->title}} : </b>
            @if ($item->subscription->expired_at == date('Y-m-d'))
              <span>Berakhir hari ini</span>
            @elseif ($item->subscription->expired_at > date('Y-m-d'))
              {{date('d/m/Y', strtotime($item->subscription->expired_at))}}
            @else
              <span>Sudah berakhir</span>
            @endif 
          @else
            -
          @endif
        </td>
        <td>{{$item->nik ?? '-'}}</td>
        <td>{{$item->profession?->title ?? '-'}}</td>
        <td>{{$item->phone_number}}</td>
        <td>{{$item->email}}</td>
        <td class="text-center">
          @if ($item->ktp)
            <button type="button"class="btn btn-primary popup_image"
              data-src="{{env('URL_ASSET').$item->ktp}}" data-title="KTP">
                <i class="fas fa-image"></i>
            </button>
          @else                      
            <i class="fas fa-times" style="color: red;"></i>
          @endif
        </td>
        <td class="text-center">
          @if ($item->npwp)
            <button type="button"class="btn btn-primary popup_image"
              data-src="{{env('URL_ASSET').$item->npwp}}" data-title="NPWP">
                <i class="fas fa-image"></i>
            </button>
          @else                      
            <i class="fas fa-times" style="color: red;"></i>
          @endif
        </td>
        <td id="action-{{$item->id}}">
          @if ($item->role == 'Mitra Kerjasama')
            <a
              href="{{url('ventures/cooperation/' . $item->id )}}"
              class="btn btn-success btn-sm">
              <i class="fas fa-handshake mr-2"></i>
              Status Kerjasama
            </a>

            <a
              href="{{url('ventures/wallet/' . $item->id )}}"
              class="btn btn-success btn-sm">
              <i class="fas fa-dollar mr-2"></i>
              Modal Disetor
            </a>

            <a
              href="{{url('ventures/saldo/' . $item->id )}}"
              class="btn btn-success btn-sm">
              <i class="fas fa-wallet mr-2"></i>
              Saldo
            </a>
          @endif

          <a
            href="{{url('ventures/find/' . $item->id )}}"
            class="btn btn-warning btn-sm">
              <i class="fas fa-link mr-2"></i>
              Detail
          </a>

          <x-partial.button-delete
            action="ventures/_delete"
            id="{{$item->id}}" />
        </td>
      </tr>
    @endforeach
  </tbody>
  <x-slot name="extra">
    {{$collection->links('vendor.pagination.bootstrap-5')}}
  </x-slot>
</x-partial.tab-role>