<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-search.customer class="col-md-12 col-12 mb-3" />

      <x-partial.tab-role href="customer">
        <thead>
          <tr>
            <th class="w-10px">No</th>
            <th>User</th>
            <th>ID Pelanggan</th>
            <th>Nama Pelanggan</th>
            <th>PIC</th>
            <th class="w-100px">Aksi</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($collection as $key => $item)
            <tr id="data-{{$item->id}}">
              <td class="numbering">{{no($key)}}</td>
              <td>{{$item->user->name}}</td>
              <td>{{$item->id}}</td>
              <td>{{$item->name}}</td>
              <td>{{$item->pic}}</td>
              <td id="action-{{$item->id}}">
                <a 
                  href="{{url('customer/find/'.$item->id)}}" 
                  class="btn btn-warning btn-sm">
                  <i class="fas fa-link mr-2"></i>
                  Detail
                </a>
              </td>
            </tr>
          @endforeach
        </tbody>

        <x-slot name="extra">
          {{$collection->links('vendor.pagination.bootstrap-5')}}
        </x-slot>
      </x-partial.tab-role>
        
    </div>
  </section>

</x-layout>