<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('opex/pengeluaran')],
      [$item->id]
    ]" /> 

  <section class="content px-3">
    <div class="card">
      <div class="card-body">
        <p class="text-bold mb-3">Kode Transaksi : <u>{{$item->id}}</u></p>

        <div class="row mb-2">
          <x-form.input 
            div="col-md-8" value="{{$item->user?->name ?? '-'}}"
            label="Dibuat Oleh" readonly />
          <x-form.input 
            div="col-md-4" value="{{$item->purchase_dated}}"
            label="Tanggal Pembelian" readonly />
        </div>

        <h4 class="text-bold">PEMBAYARAN</h4>

        <div class="row">
          <x-form.input 
            div="col-md-4" value="{{ucwords($item->payment_method)}}"
            label="Tipe Pembayaran" readonly />
        </div>
        
        <div class="d-flex mb-4">
          <div class="mr-2">
            <a href="{{base_url($item->upload_nota)}}" class="btn btn-{{$item->upload_nota ? 'success' : 'danger'}}">
              <i class="fas fa-{{$item->upload_nota ? 'check' : 'times'}} mr-2"></i>      
              File Nota
            </a>
          </div>
          <div class="mr-2">
            <a href="{{base_url($item->upload_proof_of_payment)}}" class="btn btn-{{$item->upload_proof_of_payment ? 'success' : 'danger'}}">
              <i class="fas fa-{{$item->upload_proof_of_payment ? 'check' : 'times'}} mr-2"></i>      
              Bukti Transfer
            </a>
          </div>
        </div>

        <h4 class="text-bold">PENGELUARAN</h4>

        <div class="mb-2">
          @foreach ($item->items as $e)
            <div class="row" style="border-bottom:1px solid #e9ecef">
              <x-form.input 
                div="col-md-4" value="{{$e->category->title}}"
                label="Kategori Pengeluaran" readonly />
              <x-form.input 
                div="col-md-8" value="{{$e->title}}"
                label="Nama Biaya" readonly />

              <x-form.input 
                div="col-md-2" value="{{$e->qty}}"
                label="Jumlah" readonly />
              <x-form.input 
                div="col-md-2" value="{{$e->unit}}"
                label="Satuan" readonly />
              <x-form.input 
                div="col-md-4" value="{{number_format($e->price)}}"
                label="Harga" readonly />
              <x-form.input 
                div="col-md-4" value="{{number_format($e->subtotal)}}"
                label="Subtotal" readonly />

              <x-form.input 
                div="col-md-12" value="{{$e->description ?? '-'}}"
                label="Keterangan" readonly />
            </div>
          @endforeach
        </div>

      </div>
      <div class="card-footer">
        <a 
          onclick="return history.go(-1)" 
          class="btn btn-default" 
          id="_backButton">Kembali</a>
      </div>
    </div>
  </section>

</x-layout>