<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}" 
    :items="[
      [$title, url('payment-method-type')],
      ['Edit']
    ]" />

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Edit {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('payment-method-type/_update')}}" 
        method="post" 
        enctype="multipart/form-data">
        <div class="card-body">
          <input type="hidden" name="id" value="{{$item->id}}" />
          <x-form.input 
            label="Nama" 
            name="name" 
            placeholder="Masukan nama"
            value="{{$item->name}}" />
          <x-form.input 
            label="Kode" 
            name="code" 
            placeholder="Masukan kode"
            value="{{$item->code}}" />
          <div class="form-group">
            <label for="file">Gambar {{$title}}</label>
            <br />
            <input 
              type="file" name="file" 
              id="file" 
              accept=".jpg, .png" />
            <div id="preview">
              <img 
                src="{{base_url($item->file)}}" 
                id="preview" 
                style="margin-top: 10px; width:200px; height:auto;">
            </div>
          </div>
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>