<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <div class="col-12 mb-3">
        <x-partial.table-content>
          <thead>
            <tr>
              <th class="w-10px">No</th>
              <th>Nama</th>
              <th>Kode</th>
              <th class="w-300px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($collection as $key => $item)
              <tr id="data-{{$item->id}}">
                <td class="numbering">{{no($key)}}</td>
                <td>
                  <img 
                    src="{{base_url($item->file)}}" 
                    class="w-100px mr-2" 
                    alt="type pembayaran" />
                  
                  <span>{{$item->name}}</span>
                </td>
                <td>{{$item->code}}</td>
                <td id="action-{{$item->id}}">
                  @if ($item->deleted_at)
                    <form 
                    action="{{url('payment-method-type/_delete')}}" 
                    style="display:inline-block;" 
                    class="deleteForm-{{$item->id}}">
                    <button 
                      type="button" 
                      onclick="return confirmation('{{$item->id}}', '1')" 
                      class="btn btn-success btn-sm">
                      <i class="fa-solid fa-trash-can-arrow-up mr-2"></i>
                      Pulihkan
                    </button>
                  </form>
                  @else
                    <x-partial.button-edit href="payment-method-type/edit/{{$item->id}}" />

                    <x-partial.button-delete
                      action="payment-method-type/_delete"
                      id="{{$item->id}}" />
                  @endif
                </td>
              </tr>
            @endforeach
          </tbody>
        </x-partial.table-content>
      </div>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/delete.js?ls=pulihkan')}}" 
      element="reload-withoutdescription"></script>
  </x-slot>

</x-layout>