<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-search.purchase-order class="col-md-12 mb-3" />

      <x-partial.tab-role href="po">
        <thead>
          <tr>
            <th class="w-10px">No</th>
            <th>ID</th>
            <th>Tanggal</th>
            <th>Dibuat Oleh</th>
            <th>Pelanggan</th>
            <th>Produk</th>
            <th class="w-100px">Aksi</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($collection as $key => $item)
            <tr id="data-{{$item->id}}">
              <td class="numbering">{{no($key)}}</td>
              <td>{{$item->id}}</td>
              <td>{{date('d/m/Y', strtotime($item->purchase_date))}}</td>
              <td>{{$item->user?->name ?? '-'}}</td>
              <td>{{$item->customer?->name ?? '-'}}</td>
              <td>{{$item->items_count}} Produk</td>
              <td id="action-{{$item->id}}">
                <a 
                  href="{{url('po/find/'.$item->id)}}" 
                  class="btn btn-warning btn-sm">
                  <i class="fas fa-link mr-2"></i>
                  Detail
                </a>
              </td>
            </tr>
          @endforeach
        </tbody>

        <x-slot name="extra">
          {{$collection->links('vendor.pagination.bootstrap-5')}}
        </x-slot>
      </x-partial.tab-role>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/date-input.js')}}"></script>
  </x-slot>

</x-layout>